﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace PlikiTekstowe
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            List<string> tekst = new List<string>();
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);
                }
                return tekst.ToArray();
            }
            catch (Exception e)
            {
                MessageBox.Show("Błąd odczytu pliku " + nazwaPliku + " (" + e.Message + ")");
                return null;
            }
        }

        private void fileListBox1_DwukrotneKliknieciePliku(object sender, EventArgs e, string nazwaPliku)
        {
            textBox1.Lines = CzytajPlikTekstowy(nazwaPliku);
        }
    }
}
